/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWLockStepDialog;
import filenet.vw.toolkit.runtime.property.VWAccessModeTableCellRenderer;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepFieldsTableModel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.images.VWImageLoader;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.table.VWExpandButtonEditor;
import filenet.vw.toolkit.utils.table.VWExpandButtonRenderer;
import filenet.vw.toolkit.utils.table.VWFieldNameRenderer;
import filenet.vw.toolkit.utils.table.VWFieldTypeRenderer;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class VWStepFieldsPanel
extends VWStepPropTabPanel
implements IVWMouseActionListener {
    JScrollPane m_tablePanel = null;
    VWTable m_fieldsTable = null;
    private VWExpandButtonRenderer m_expandBtnRenderer = new VWExpandButtonRenderer();
    private VWExpandButtonEditor m_expandBtnEditor = new VWExpandButtonEditor(new JButton());
    private VWFieldTypeRenderer m_fieldTypeRenderer = new VWFieldTypeRenderer();
    private VWFieldNameRenderer m_fieldNameRenderer = new VWFieldNameRenderer();
    private VWFieldsCellRenderer m_fieldsCellRenderer = new VWFieldsCellRenderer();
    private VWFieldsCellEditor m_fieldsCellEditor = null;
    VWLockStepDialog m_lockStepDlg = null;
    private VWAccessModeTableCellRenderer m_accessModeCellRenderer = new VWAccessModeTableCellRenderer();
    private JPanel m_topPanel = new JPanel();
    private VWMouseAdapter m_fieldsTableMouseListener = null;
    private JPopupMenu m_popup = null;
    private JMenuItem m_miEditValue = null;
    private ActionListener m_miEditValueActionListener = null;
    private int m_editRow = -1;
    private int m_editCol = -1;
    private MouseEvent m_editEvent = null;
    VWStepFieldsTableModel m_fieldsTableModel = new VWStepFieldsTableModel();
    JButton m_editFieldBtn = new JButton(VWImageLoader.createImageIcon("edit.gif"));

    public void createPopup(MouseEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof JTable) || source != this.m_fieldsTable) {
            return;
        }
        JTable table = (JTable)source;
        if (table.isEditing()) {
            table.removeEditor();
        }
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int col = table.columnAtPoint(point);
        if (row == -1 || col == -1) {
            return;
        }
        this.m_editRow = row;
        this.m_editCol = col;
        this.m_editEvent = evt;
        if (!table.isRowSelected(row)) {
            table.setRowSelectionInterval(row, row);
        }
        if (col == 3) {
            if (!this.isLiveData()) {
                return;
            }
            if (this.m_popup == null) {
                this.m_popup = new JPopupMenu();
            } else {
                this.m_popup.removeAll();
            }
            if (this.m_miEditValue == null) {
                this.m_miEditValue = new JMenuItem(VWResource.s_editValue);
                this.m_miEditValueActionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (!VWStepFieldsPanel.this.isEditable()) {
                            return;
                        }
                        VWStepFieldsPanel.this.m_fieldsTable.editCellAt(VWStepFieldsPanel.this.m_editRow, VWStepFieldsPanel.this.m_editCol);
                        VWStepFieldsPanel.this.m_fieldsCellEditor.shouldSelectCell(new MouseEvent(VWStepFieldsPanel.this.m_fieldsTable, VWStepFieldsPanel.this.m_editEvent.getID(), VWStepFieldsPanel.this.m_editEvent.getWhen(), VWStepFieldsPanel.this.m_editEvent.getModifiers(), VWStepFieldsPanel.this.m_editEvent.getX(), VWStepFieldsPanel.this.m_editEvent.getY(), 2, false));
                    }
                };
                this.m_miEditValue.addActionListener(this.m_miEditValueActionListener);
            }
            this.m_popup.add(this.m_miEditValue);
            this.m_popup.show(this.m_fieldsTable, point.x, point.y);
        }
    }

    public void doubleClickedItem(MouseEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof JTable) || source != this.m_fieldsTable) {
            return;
        }
        JTable table = (JTable)source;
        if (table.isEditing()) {
            table.removeEditor();
        }
        Point point = evt.getPoint();
        int row = table.rowAtPoint(point);
        int col = table.columnAtPoint(point);
        if (row == -1 || col == -1) {
            return;
        }
        this.m_editRow = row;
        this.m_editCol = col;
        this.m_editEvent = evt;
        if (!table.isRowSelected(row)) {
            table.setRowSelectionInterval(row, row);
        }
        if (col == 3) {
            if (!this.isEditable()) {
                return;
            }
            this.m_fieldsTable.editCellAt(this.m_editRow, this.m_editCol);
            this.m_fieldsCellEditor.shouldSelectCell(new MouseEvent(this.m_fieldsTable, this.m_editEvent.getID(), this.m_editEvent.getWhen(), this.m_editEvent.getModifiers(), this.m_editEvent.getX(), this.m_editEvent.getY(), 2, false));
        }
    }

    protected void initData() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        try {
            if (this.m_fieldsTableModel == null) {
                this.m_fieldsTableModel = new VWStepFieldsTableModel();
            }
            if (this.m_stepOccurrence != null) {
                if (this.m_bStepView) {
                    this.m_fieldsTableModel.setData(this.m_stepOccurrence, true);
                } else if (this.m_participant != null) {
                    this.m_fieldsTableModel.setData(this.m_participant, true);
                } else {
                    this.m_fieldsTableModel.setData((VWTrkStepOccurrence)null, true);
                }
            } else {
                this.m_fieldsTableModel.clearData();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEditable() {
        if (!this.isLiveData()) {
            return false;
        }
        if (!this.isDataEditable()) {
            try {
                if (this.m_lockStepDlg == null) {
                    this.m_lockStepDlg = this.m_bStepView ? new VWLockStepDialog(this.m_parentFrame, this.m_stepOccurrence) : new VWLockStepDialog(this.m_parentFrame, this.m_participant);
                    if (this.m_lockStepDlg != null && this.m_lockStepDlg.isAskAgain()) {
                        this.m_lockStepDlg.setVisible(true);
                    }
                }
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
            finally {
                if (this.m_lockStepDlg != null) {
                    this.m_lockStepDlg.removeReferences();
                    this.m_lockStepDlg = null;
                }
            }
        }
        return this.isDataEditable();
    }

    protected void preSetupLayout() {
        this.m_topPanel.setLayout(new BoxLayout(this.m_topPanel, 2));
        this.m_topPanel.add(new Label(VWResource.s_label.toString(VWResource.s_fields)));
        this.m_editFieldBtn.setMargin(new Insets(0, 0, 0, 0));
        this.m_topPanel.add(this.m_editFieldBtn);
        this.setLayout(new BorderLayout());
    }

    protected void setupLayout() {
        this.setupTablePane();
        this.add((Component)this.m_tablePanel, "Center");
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
    }

    protected void setupTablePane() {
        TableColumnModel columnModel = null;
        int width = 0;
        this.m_fieldsTable = new VWTable();
        this.m_fieldsTable.setRowSelectionAllowed(true);
        this.m_fieldsTable.setSelectionMode(0);
        this.m_fieldsTable.setModel(this.m_fieldsTableModel);
        columnModel = this.m_fieldsTable.getColumnModel();
        TableColumn columnExpand = columnModel.getColumn(0);
        TableColumn columnName = columnModel.getColumn(1);
        TableColumn columnType = columnModel.getColumn(2);
        TableColumn columnValue = columnModel.getColumn(3);
        columnExpand.setMinWidth(15);
        columnExpand.setMaxWidth(15);
        columnType.setMinWidth(20);
        width = this.m_fieldTypeRenderer.getMaxWidth(true);
        if (width != 0) {
            columnType.setMaxWidth(width += 4);
            columnType.setPreferredWidth(width);
        }
        columnName.setMinWidth(100);
        columnValue.setMinWidth(100);
        columnExpand.setCellRenderer(this.m_expandBtnRenderer);
        columnExpand.setCellEditor(this.m_expandBtnEditor);
        columnType.setCellRenderer(this.m_fieldTypeRenderer);
        columnName.setCellRenderer(this.m_fieldNameRenderer);
        columnValue.setCellRenderer(this.m_fieldsCellRenderer);
        columnValue.setCellEditor(this.m_fieldsCellEditor);
        this.m_tablePanel = new JScrollPane(this.m_fieldsTable);
        columnName.sizeWidthToFit();
        columnValue.sizeWidthToFit();
        this.m_fieldsTable.addMouseListener(this.m_fieldsTableMouseListener);
    }

    protected void stopEditing() {
        if (this.m_fieldsCellEditor != null) {
            this.m_fieldsCellEditor.stopCellEditing();
        }
    }

    protected void updateDisplay() {
        this.stopEditing();
        this.m_fieldsTableModel.fireTableDataChanged();
    }

    public VWStepFieldsPanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        super(parentFrame, propPanel);
        this.m_type = 4;
        this.m_fieldsCellEditor = new VWFieldsCellEditor(this.m_parentFrame);
        this.m_fieldsTableMouseListener = new VWMouseAdapter(this){
            private boolean m_bTableAdjusted;
            {
                this.m_bTableAdjusted = false;
            }

            public void mouseEntered(MouseEvent event) {
                if (!this.m_bTableAdjusted) {
                    VWStepFieldsPanel.this.m_fieldsTable.updateUI();
                    this.m_bTableAdjusted = true;
                }
                super.mouseEntered(event);
            }
        };
        this.preSetupLayout();
    }

    public void removeReferences() {
        super.removeReferences();
        if (this.m_tablePanel != null) {
            this.m_tablePanel.removeAll();
            this.m_tablePanel = null;
        }
        if (this.m_fieldsTable != null) {
            if (this.m_fieldsTableMouseListener != null) {
                this.m_fieldsTable.removeMouseListener(this.m_fieldsTableMouseListener);
            }
            TableColumnModel columnModel = this.m_fieldsTable.getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                columnModel.getColumn(i).setCellRenderer(null);
                columnModel.getColumn(i).setCellEditor(null);
                columnModel.getColumn(i).setHeaderRenderer(null);
            }
            this.m_fieldsTable.removeReferences();
            this.m_fieldsTable = null;
        }
        if (this.m_fieldsTableModel != null) {
            this.m_fieldsTableModel.removeReferences();
            this.m_fieldsTableModel = null;
        }
        this.m_expandBtnRenderer = null;
        this.m_expandBtnEditor = null;
        this.m_fieldTypeRenderer = null;
        this.m_fieldNameRenderer = null;
        this.m_fieldsCellRenderer = null;
        if (this.m_fieldsCellEditor != null) {
            this.m_fieldsCellEditor.removeReferences();
            this.m_fieldsCellEditor = null;
        }
        if (this.m_lockStepDlg != null) {
            this.m_lockStepDlg.removeReferences();
            this.m_lockStepDlg = null;
        }
        this.m_accessModeCellRenderer = null;
        if (this.m_topPanel != null) {
            this.m_topPanel.removeAll();
            this.m_topPanel = null;
        }
        if (this.m_fieldsTableMouseListener != null) {
            this.m_fieldsTableMouseListener.removeReferences();
            this.m_fieldsTableMouseListener = null;
        }
        if (this.m_popup != null) {
            this.m_popup.removeAll();
            this.m_popup = null;
        }
        if (this.m_miEditValue != null) {
            this.m_miEditValue.removeActionListener(this.m_miEditValueActionListener);
            this.m_miEditValue = null;
        }
        this.m_miEditValueActionListener = null;
        this.m_editEvent = null;
        this.m_editFieldBtn = null;
        this.setLayout(null);
        this.removeAll();
    }
}

